/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import jclass.bwt.JCSerializable;
import jclass.chart.AreaChartDraw;
import jclass.chart.BarChartDraw;
import jclass.chart.CandleChartDraw;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Drawable;
import jclass.chart.HiloChartDraw;
import jclass.chart.JCChartArea;
import jclass.chart.JCDataIndex;
import jclass.chart.PieChartDraw;
import jclass.chart.PlotChartDraw;
import jclass.chart.PolarChartDraw;
import jclass.chart.RadarChartDraw;
import jclass.chart.SBarChartDraw;
import jclass.chart.TrackChange;

abstract class ChartDraw
extends TrackChange
implements Drawable,
JCSerializable {
    int chartType = -1;
    ChartDataView dataObject;
    JCChartArea chartArea;
    int numActiveDataSeries;
    public static final int BASE_MARGIN = 10;

    public ChartDraw(ChartDataView chartDataView) {
        this.dataObject = chartDataView;
        this.chartArea = chartDataView.chart.chartArea;
        if (this.dataObject != null) {
            this.chartType = this.dataObject.getChartType();
        }
    }

    public static ChartDraw makeDrawObject(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        switch (chartDataView.getChartType()) {
            case 0: 
            case 1: {
                chartDraw = new PlotChartDraw(chartDataView);
                break;
            }
            case 2: {
                chartDraw = new PolarChartDraw(chartDataView);
                break;
            }
            case 3: 
            case 4: {
                chartDraw = new RadarChartDraw(chartDataView);
                break;
            }
            case 5: {
                chartDraw = new HiloChartDraw(chartDataView);
                break;
            }
            case 7: {
                chartDraw = new CandleChartDraw(chartDataView);
                break;
            }
            case 8: {
                chartDraw = new AreaChartDraw(chartDataView);
                break;
            }
            case 9: {
                chartDraw = new BarChartDraw(chartDataView);
                break;
            }
            case 10: {
                chartDraw = new SBarChartDraw(chartDataView);
                break;
            }
            case 11: {
                chartDraw = new PieChartDraw(chartDataView);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal chart type specified in ChartDraw");
            }
        }
        return chartDraw;
    }

    public void recalc() {
        this.numActiveDataSeries = 0;
        ChartDataViewSeries[] chartDataViewSeriesArray = this.dataObject.getSeries();
        if (chartDataViewSeriesArray == null || chartDataViewSeriesArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            if (chartDataViewSeriesArray[n].getIsShowing()) {
                ++this.numActiveDataSeries;
            }
            ++n;
        }
    }

    public void setChanged(boolean bl) {
        super.setChanged(bl);
        if (!this.changed && this.dataObject != null) {
            this.dataObject.setChanged(false, false);
        }
    }

    public void setChanged(boolean bl, boolean bl2) {
        if (bl2) {
            this.setChanged(bl);
            return;
        }
        this.changed = bl;
        if (!this.changed && this.dataObject != null) {
            this.dataObject.setChanged(false, false);
        }
    }

    JCDataIndex pick(Point point, int n) {
        return null;
    }

    Point unpick(int n, int n2) {
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        return -1;
    }

    public abstract void draw(Graphics var1);
}

